IF EXISTS (SELECT * FROM SYS.triggers WHERE NAME = 'TRG_EST_SNGPC_SAIDA_ESTOQUE_DELETE') 
BEGIN
	DROP TRIGGER TRG_EST_SNGPC_SAIDA_ESTOQUE_DELETE
END


SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER dbo.TRG_EST_SNGPC_SAIDA_ESTOQUE_DELETE ON dbo.EST_SNGPC_SAIDA
WITH EXECUTE AS CALLER
FOR DELETE
AS
BEGIN

	-- DECLARAO DAS VARIVEIS
	DECLARE @CD_SAI     INT;
	DECLARE @CD_MOV     INT;
	DECLARE @CD_EMP     INT;
	DECLARE @CD_FILIAL  INT;
	DECLARE @CD_PROD    INT;
	DECLARE @DT_MOV     DATETIME;
	DECLARE @QT_LOTE    INT;

	-- DEFINIO DAS VARIVEIS
	SELECT
		@CD_SAI      = D.CD_SAI_SNGPC
		, @CD_EMP    = D.CD_EMP
		, @CD_FILIAL = D.CD_FILIAL
		, @CD_PROD   = A.CD_PROD
		, @DT_MOV    = D.DT_MOV
		, @QT_LOTE   = D.QT_LOTE
	FROM
		DELETED D
		INNER JOIN EST_PROD_EST_SNGPC_LOTE A ON
			D.CD_LOTE = A.CD_LOTE

	-- SELECIONA A MOVIMENTAO GERAL CORRESPONDENTE  SADA
	SELECT
		@CD_MOV = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI
	WHERE
		CD_SAI_SNGPC = @CD_SAI

	/******************************************************************/
	/* PROCESSO PARA EXCLUSO DO REGISTRO NA TABELA EST_SNGPC_ENT_SAI */
	/******************************************************************/

	-- EXCLUI O REGISTRO
	DELETE FROM EST_SNGPC_ENT_SAI WHERE CD_MOV = @CD_MOV;

	/**********************************************/
	/* PROCESSO PARA ATUALIZAO DO ESTOQUE FINAL */
	/* DOS REGISTROS NA TABELA EST_SNGPC_ENT_SAI  */
	/**********************************************/

	-- ATUALIZA ESTOQUE FINAL DE TODAS AS MOVIMENTAES POSTERIORES
	UPDATE
		EST_SNGPC_ENT_SAI
	SET
		QT_FINAL = QT_FINAL + @QT_LOTE
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND (DT_MOV > @DT_MOV OR (DT_MOV = @DT_MOV AND CD_MOV > @CD_MOV));
END
GO